# -*- coding: utf-8 -*-
"""
Created on Tue May 21 14:40:29 2019

@author: adijkstra
"""
"""
NOTE!!!! THIS CODE ONLY WORKS WHEN YOUR X-AXIS DATA IS EQUALLY SPACED

the individual version is intended to fine tune individual fits and add them to an already existing data set.
"""

import numpy as np
from numpy import exp, linspace, random
import pandas as pd
import matplotlib.pyplot as plt
import os
from scipy.optimize import curve_fit
from scipy.special import gamma
from scipy import signal
from scipy.ndimage import convolve1d
from scipy.ndimage import correlate1d

#============Get the current directory
path = os.getcwd()
print("The current directory is: %s" % path )
#==================================================================



#specify from which file the data comes
fileNameTemp ='H06138_LICorrIntensityTemperatures.txt'
fileNamePow = 'H06138_LICorrIntensityPowers.txt'
importedFileTemp=np.array(pd.read_csv(fileNameTemp, sep='\t', header=None))
importedFilePow=np.array(pd.read_csv(fileNamePow, sep='\t', header=None))

#select the data desired
#Energy scale
energyData = importedFileTemp[7:,1]
energyData = energyData.astype(np.float)  #turn into a float data format
#Intensity measured at lowT
Intensity4K = np.array(importedFileTemp[7:,32])
Intensity4K = Intensity4K.astype(np.float)
Normalized4K =np.divide(Intensity4K,np.amax(Intensity4K))
#Intensity at high T
Intensity280K = np.array(importedFileTemp[7:,2])
Intensity280K = Intensity280K.astype(np.float)
Normalized280K =np.divide(Intensity280K,np.amax(Intensity280K))
"""

#Plot the normalized graphs to show what I am working with
plt.plot(energyData, Normalized4K, 'r^')
plt.plot(energyData, Normalized280K, 'b^')
plt.axis([0.2, 0.55, 0,1.2])
plt.show()

"""


def gaussian(x, amp, cen, wid):
    return amp * exp(-(x-cen)**2 / wid)

def simpleDOS(E, Eg, A, normalized=True):
    if np.isscalar(E) == False:
        DOS=np.zeros(int(np.size(E)))
        n=0
        for i in E:
            if i<=Eg:
                DOS[n]=0.0
            else:
                DOS[n]=np.multiply(A,np.sqrt(i-Eg))
                
            n+=1
        return DOS     

    else:
        return np.multiply(A,np.sqrt(E-Eg))

    
def fermiDirac(E,Eg,T,Eshift=0):
    k=8.61733e-5 #[eV/K]
    return np.divide(1,(1+np.exp(np.divide((E-Eg-Eshift),(k*T)))))

def urbachTail(E, Eg, gam, theta=1, normalized=False):
    N=np.divide(1,(2*gam*gamma(1+np.divide(1,theta)))) #This normalization factor makes that the area under neath the graph remains to be 1
    if normalized == False:
        return np.multiply(np.exp(-np.power(np.absolute((np.divide((E-Eg),gam))),theta)),N)
    elif normalized == True:
        return np.divide(np.multiply(np.exp(-np.power(np.absolute((np.divide((E-Eg),gam))),theta)),N), np.amax(np.multiply(np.exp(-np.power(np.absolute((np.divide((E-Eg),gam))),theta)),N)))
    
    
def tailedDOS(E, Eg, A, gam, theta=1, normalized=False):
    #First make an array that will be used to define the urback tail, important is that I know the length of the array and that the peak is at te exact center
    EStepsize=np.divide((E[40]-E[0]),40) #Get the energy stepsize
    HalfLength = int(1000) #Choose a value for the length of the array used for the peak function 
    EDataUT = np.zeros(HalfLength*2) #define the array that will be used and fill the array with energy values with zero at the center of the array.
    for i in range (HalfLength):
        EDataUT[i]=(i-HalfLength+0.5)*EStepsize
        EDataUT[i+HalfLength]=(i+0.5)*EStepsize
    #Now the FULL convolution can be done between the urbach tail and the simple DOS    
    tailDOS=np.convolve(urbachTail(EDataUT, 0, gam, theta), simpleDOS(E, Eg, A), 'full')/sum(urbachTail(EDataUT, 0, gam, theta))
    #The convolution is now exactly shifted by half of the urbach tail length minus one cell So now I correct for this and we can return the array.
    tailDOS=tailDOS[HalfLength-1:]
    tailDOS=tailDOS[0:int(np.size(E))]
    #Then return the signal
    if normalized == False:
        return tailDOS
    elif normalized == True:
        return np.divide(tailDOS,np.amax(tailDOS))
    
def simpleDOS_FD(E, Eg, A, T, Eshift=0, normalized=False):
    if normalized == False:
        return np.multiply(simpleDOS(E,Eg,A),fermiDirac(E,Eg,T, Eshift))
    elif normalized == True:
        return np.divide(np.multiply(simpleDOS(E,Eg,A),fermiDirac(E,Eg,T, Eshift)),np.amax(np.multiply(simpleDOS(E,Eg,A),fermiDirac(E,Eg,T, Eshift))))

def tailedDOS_FD(E, Eg, A, T, gam, theta=1, Eshift=0.0, normalized=False):
    if normalized == False:
        return np.multiply(tailedDOS(E, Eg, A, gam, theta),fermiDirac(E,Eg,T,Eshift))
    elif normalized == True:
        return np.divide(np.multiply(tailedDOS(E, Eg, A, gam, theta),fermiDirac(E,Eg,T,Eshift)),np.amax(np.multiply(tailedDOS(E, Eg, A, gam, theta),fermiDirac(E,Eg,T,Eshift))))

def tailedAbsorptivity (E, Eg, A, gam, theta=1, Eshift=0, d=1, normalized=False):
    #d is a characeristic length scale of absorption
    if normalized == False:
        return 1-np.exp(-tailedDOS(E, Eg, A, gam, theta)*d)
    elif normalized == True:
        return np.divide((1-np.exp(-tailedDOS(E, Eg, A, gam, theta)*d)),np.amax(1-np.exp(-tailedDOS(E, Eg, A, gam, theta)*d)))
    
def simpleAbsorptivity (E, Eg, A, Eshift=0, d=1, normalized=False):
    #d is a characeristic length scale of absorption in paper used as fitting parameter
    if normalized == False:
        return 1-np.exp(-simpleDOS(E, Eg, A)*d)
    elif normalized == True:
        return np.divide((1-np.exp(-simpleDOS(E, Eg, A)*d)),np.amax(1-np.exp(-simpleDOS(E, Eg, A)*d)))
    
def tailedAbsortivityOccCorr(E, Eg, A, T, gam, Dmu, d=1, theta=1, Eshift=0, normalized=False):
    k=8.61733e-5 #[eV/K]
    #d is a characeristic length scale of absorption in paper used as fitting parameter
    temp=np.multiply(tailedDOS(E, Eg, A, gam, theta),(1-np.divide(2,np.exp(np.divide((E-Dmu),(2*np.multiply(k,T))))+1)))
    temp=1-np.exp(-temp*d)
    #temp=(1-np.divide(2,np.exp(np.divide((E-Dmu),(2*np.multiply(k,T))))+1))
    if normalized == False:
        return temp
    elif normalized == True:
        return np.divide(temp,temp[-1])
    
    
def LSW_tailedAbs_PL (E, Eg, A, T, gam, Dmu, d=1, theta=1, Eshift=0, normalized=False):
    k=8.61733e-5 #[eV/K]
    temp=np.divide(np.multiply(np.power(E,2),tailedAbsortivityOccCorr(E, Eg, A, T, gam, Dmu, d, theta, Eshift=0.0, normalized=False)),(np.exp(np.divide((E-Dmu),(np.multiply(k,T))))-1))
    #temp=np.divide(1,np.exp(np.divide((E-Dmu),(np.multiply(k,T))))-1)
    if normalized == False:
        return temp
    elif normalized == True:
        return np.divide(temp,np.amax(temp))
    
def LSW_tailedAbsNoCorr_PL (E, Eg, A, T, gam, Dmu, d=1, theta=1, Eshift=0, normalized=False):
    k=8.61733e-5 #[eV/K]
    temp=np.divide(np.multiply(np.power(E,2),tailedAbsorptivity(E, Eg, A, gam, theta, Eshift=0.0, normalized=False)),(np.exp(np.divide((E-Dmu),(np.multiply(k,T))))-1))
    #temp=np.divide(1,np.exp(np.divide((E-Dmu),(np.multiply(k,T))))-1)
    if normalized == False:
        return temp
    elif normalized == True:
        return np.divide(temp,np.amax(temp[3000:]))
    

"""
==================================================
===============SET THE VARIABLES==================
==================================================
"""
BGEnergy=0.35
Temperature=150
gam=0.006
DeltaMu=0.3
theta=1
A=5
EfShift=0.00
startCell=50
dataLength=140
absorptionLength=1

#energyData= energyData[startCell:dataLength]
#Normalized280K=Normalized280K[startCell:dataLength]
#Normalized4K=Normalized4K[startCell:dataLength]

#This is a scale I use to get a higher density of data points
energySimu = np.arange(0.01, 0.9, 0.001)
energySimu = energySimu.astype(np.float)

"""
==================================================
===============SET THE VARIABLES==================
==================================================
"""








###############################################################
#Fitting with the Lasher-Stern-Wurfel model
#Temperature dependent
####################################################


#==================Setting fitting parameters
BGEnergy=0.29
Temperature=20
gam=0.02
theta=1
A=100
EfShift=0.00
FitStartElement=35
FitEndElement=160
absorptionLength=1
DeltaMu=0.37

#Choose whether to fit the data or simply import it from the previous file
SpectrumNumber=1
REFIT_DATA=True
SAVE_REFIT=True
#============================



#make a new directory of all the output of the PL_V_T data
path = os.getcwd()
print("The current directory is: %s" % path )
newnewfolderpath=path+"/LSW_PL_fitting_T-series"
try:
    os.mkdir(newnewfolderpath)
except OSError:
    print('Creation of folder failed')
else:
    print('Succesfully created folder')
try:
    os.chdir(newnewfolderpath)
except OSError:
    print('Failed to change directories to new folder')
else:    
    print('Changed directory to new new folder: ' + newnewfolderpath)





"""
================================================
===========Loop to fit all the data=============
================================================
"""




#Check how many things I imported
importSizeTemp=np.size(importedFileTemp[:1])-2


#Energy scale
energyData = importedFileTemp[7:,1]
energyData = energyData.astype(np.float)  #turn into a float data format


#Import the previous fitting results
results_LSW_PL=np.array(pd.read_csv("Fitting_results_" + fileNameTemp + ".txt", sep='\t', header=None))
results_LSW_PL=results_LSW_PL[2:]
results_LSW_PL = results_LSW_PL.astype(np.float)

#import the data of the specific spectrum
data=importedFileTemp[7:,SpectrumNumber+2]
data_original = data.astype(np.float)
data = np.divide(data_original, np.amax(data_original))

#This line is just to make sure that BestVal_biGauss_PL has the right value when imported
BestVal_LSW_PL=results_LSW_PL[SpectrumNumber,1:6]

#Calculate the shape fo the fitted spectrum
calculated_LSW_PL = LSW_tailedAbs_PL(energyData, BestVal_LSW_PL[0], BestVal_LSW_PL[1], BestVal_LSW_PL[2], BestVal_LSW_PL[3], BestVal_LSW_PL[4])
calculated_LSW_PL_normalized = LSW_tailedAbs_PL(energyData, BestVal_LSW_PL[0], BestVal_LSW_PL[1], BestVal_LSW_PL[2], BestVal_LSW_PL[3], BestVal_LSW_PL[4], normalized=True)



#First print the spectrum of choice with previous parameters
plt.figure(figsize=(15, 5))
plt.subplot(1, 3, 1)
plt.plot(energyData, data, 'r')
plt.plot(energyData, calculated_LSW_PL , 'b--')
plt.text(0.26, 1.15, "T= " + str(importedFileTemp[3,SpectrumNumber+2]) + "K", horizontalalignment='left', verticalalignment='top', fontsize=18)
plt.axvline(x=BestVal_LSW_PL[0],linewidth=1.0, dashes=(5,5))
plt.axis([0.2, 0.60, 0.0, 1.2])
plt.subplot(1, 3, 2)
plt.semilogy(energyData, data, 'r')
plt.semilogy(energyData, calculated_LSW_PL, 'b--')
plt.axvline(x=BestVal_LSW_PL[0],linewidth=1.0, dashes=(5,5))
plt.axis([0.2, 0.60, 0.001, 1.2])
plt.subplot(1, 3, 3)
plt.semilogy(energySimu,tailedAbsortivityOccCorr(energySimu, BestVal_LSW_PL[0], BestVal_LSW_PL[1], BestVal_LSW_PL[2], BestVal_LSW_PL[3], BestVal_LSW_PL[4], d=1, theta=1, Eshift=0, normalized=True), label='Absty_OcCor')
plt.semilogy(energySimu,tailedAbsorptivity (energySimu, BestVal_LSW_PL[0],BestVal_LSW_PL[1], BestVal_LSW_PL[3], theta=1, Eshift=0, d=1, normalized=True), label='TailedAbsty')
plt.semilogy(energySimu,simpleAbsorptivity (energySimu, BestVal_LSW_PL[0],BestVal_LSW_PL[1], normalized=True), label='SimpleAbsty')
plt.legend(loc='lower left')
plt.axis([0.25, 0.41, 0.01, 1.1])
#Line indicating the bandgap
plt.axvline(x=BestVal_LSW_PL[0],linewidth=2.0, dashes=(5,5), color='g')
#line indicating the fermisplitting
plt.axvline(x=BestVal_LSW_PL[4],linewidth=2.0, dashes=(5,5), color='r')
plt.show()





if REFIT_DATA==True:
    #Make initial values
    #InVal_LSW_PL = [BGEnergy, A, Temperature, gam, DeltaMu]  # for [amp, cen, wid]
    InVal_LSW_PL = results_LSW_PL[SpectrumNumber,1:6]
    
    #initialize fitting result array
    BestVal_LSW_PL_REFIT = np.zeros(5)
 
    try: BestVal_LSW_PL_REFIT, covar = curve_fit(LSW_tailedAbs_PL, energyData[FitStartElement : FitEndElement], data[FitStartElement:FitEndElement], p0=InVal_LSW_PL)
    except:
       print("Something happend!")
    
    #Save the temperature of the spectrum to the fit and the fitting results
    results_LSW_PL[SpectrumNumber,1:6]=BestVal_LSW_PL_REFIT
    results_LSW_PL[SpectrumNumber,0]=importedFileTemp[3,SpectrumNumber+2]   
    #Do some after processing to get aditional values:
    #calculate the fitted spectrum
    calculated_LSW_PL = LSW_tailedAbs_PL(energyData, BestVal_LSW_PL_REFIT[0], BestVal_LSW_PL_REFIT[1], BestVal_LSW_PL_REFIT[2], BestVal_LSW_PL_REFIT[3], BestVal_LSW_PL_REFIT[4])
    calculated_LSW_PL_normalized = LSW_tailedAbs_PL(energyData, BestVal_LSW_PL_REFIT[0], BestVal_LSW_PL_REFIT[1], BestVal_LSW_PL_REFIT[2], BestVal_LSW_PL_REFIT[3], BestVal_LSW_PL_REFIT[4], normalized=True)
    #Determine at which energy the maximum occurs
    results_LSW_PL[SpectrumNumber,6]=energyData[np.argmax(calculated_LSW_PL)]
    #Determine the intensity by integrating the graph and multiplying with the height
    results_LSW_PL[SpectrumNumber,7]=np.multiply(np.trapz(calculated_LSW_PL, energyData),np.amax(data_original))
    

    if True:
        plt.figure(figsize=(15, 5))
        plt.subplot(1, 3, 1)
        plt.plot(energyData, data, 'r')
        plt.plot(energyData, calculated_LSW_PL , 'b--')
        plt.text(0.26, 1.15, "T= " + str(importedFileTemp[3,SpectrumNumber+2]) + "K", horizontalalignment='left', verticalalignment='top', fontsize=18)
        plt.axvline(x=BestVal_LSW_PL[0],linewidth=1.0, dashes=(5,5))
        plt.axvline(x=energyData[FitStartElement],linewidth=1.0, color='g')
        plt.axvline(x=energyData[FitEndElement],linewidth=1.0, color='g')
        plt.axis([0.2, 0.60, 0.0, 1.2])
        plt.subplot(1, 3, 2)
        plt.semilogy(energyData, data, 'r')
        plt.semilogy(energyData, calculated_LSW_PL, 'b--')
        plt.axvline(x=BestVal_LSW_PL[0],linewidth=1.0, dashes=(5,5))
        plt.axvline(x=energyData[FitStartElement],linewidth=1.0, color='g')
        plt.axvline(x=energyData[FitEndElement],linewidth=1.0, color='g')
        plt.axis([0.2, 0.60, 0.001, 1.2])
        plt.subplot(1, 3, 3)
        plt.semilogy(energySimu,tailedAbsortivityOccCorr(energySimu, BestVal_LSW_PL[0], BestVal_LSW_PL[1], BestVal_LSW_PL[2], BestVal_LSW_PL[3], BestVal_LSW_PL[4], d=1, theta=1, Eshift=0, normalized=True), label='Absty_OcCor')
        plt.semilogy(energySimu,tailedAbsorptivity (energySimu, BestVal_LSW_PL[0],BestVal_LSW_PL[1], BestVal_LSW_PL[3], theta=1, Eshift=0, d=1, normalized=True), label='TailedAbsty')
        plt.semilogy(energySimu,simpleAbsorptivity (energySimu, BestVal_LSW_PL[0],BestVal_LSW_PL[1], normalized=True), label='SimpleAbsty')
        plt.legend(loc='lower left')
        plt.axis([0.25, 0.41, 0.01, 1.1])
        #Line indicating the bandgap
        plt.axvline(x=BestVal_LSW_PL[0],linewidth=2.0, dashes=(5,5), color='g')
        #line indicating the fermisplitting
        plt.axvline(x=BestVal_LSW_PL[4],linewidth=2.0, dashes=(5,5), color='r')
        #save the figure in the current directory
        #plt.savefig('LSW_PL_'+ str(importedFileTemp[3,i+2]) + 'K.png')
        plt.show()
        
    #This resaves the whole data array when a fit is improved  
    if SAVE_REFIT==True:
        #create a .txt file with the same name as the h5 file and save in the same location
        Header='\r\n'.join(["Temperature\tBandgap\tScalingFactor\tPLTemperature\tGamma\tDeltaMu\tPeakCenter\tIntensity\ttrapz Intensity", "K\teV\t-\tK\teV\teV\teV\ta.u.\ta.u."])
        np.savetxt("Fitting_results_" + fileNameTemp + ".txt", results_LSW_PL, fmt='%.5e', delimiter='\t', header=Header, newline='\r\n', comments='')

        #Output the results
        #print(Header)
        #print(results_LSW_PL)
        print("new file saved")


